/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.tca;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.dom.DataSourceFilter;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.AbstractQFunction;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DataSourceTcaSource
extends AbstractQFunction {
    TimeSeriesBrowse tsb;
    boolean needToRead;
    QDataSet ds;
    QDataSet tlim;
    QDataSet bundleDs;
    DataSource dss;
    QDataSet error;
    QDataSet errorNoDs;
    QDataSet nonValueDs;
    QDataSet initialError;
    DataSourceFilter dsf;
    static final Logger logger = LoggerManager.getLogger((String)"autoplot.tca.uritcasource");
    private MutablePropertyDataSet exampleInput = null;

    public DataSourceTcaSource(DataSourceFilter node) throws Exception {
        EnumerationUnits eu = new EnumerationUnits("UriTcaSource");
        this.error = DataSetUtil.asDataSet((Datum)eu.createDatum((Object)"Error"));
        this.errorNoDs = DataSetUtil.asDataSet((Datum)eu.createDatum((Object)"No Data"));
        this.nonValueDs = DataSetUtil.asDataSet((Datum)eu.createDatum((Object)" "));
        try {
            this.dsf = node;
            DataSource dss1 = node.getController().getDataSource();
            this.initialError = null;
            this.tsb = (TimeSeriesBrowse)dss1.getCapability(TimeSeriesBrowse.class);
            this.dss = dss1;
            this.needToRead = true;
        }
        catch (Exception lex) {
            logger.log(Level.WARNING, lex.getMessage(), lex);
            this.initialError = DataSetUtil.asDataSet((Datum)eu.createDatum((Object)lex.toString()));
        }
    }

    private void doRead() throws Exception {
        NullProgressMonitor mon = new NullProgressMonitor();
        if (this.tsb != null) {
            logger.log(Level.FINE, "reading TCAs from TSB {0}", this.tsb.getURI());
        } else {
            logger.log(Level.FINE, "reading TCAs from {0}", this.dss);
        }
        this.needToRead = false;
        this.ds = this.dss.getDataSet(mon.getSubtaskMonitor("read data"));
        this.ds = DataSetOps.sprocess((String)this.dsf.getFilters(), (QDataSet)this.ds, (ProgressMonitor)mon.getSubtaskMonitor("sprocess"));
        if (this.ds == null) {
            logger.log(Level.FINE, "doRead getDataSet got null ");
        } else {
            logger.log(Level.FINE, "doRead got: {0}", this.ds);
            QDataSet dep0 = SemanticOps.xtagsDataSet((QDataSet)this.ds);
            if (!DataSetUtil.isMonotonicAndIncreasing((QDataSet)dep0)) {
                logger.warning("TCA contains data which is not monotonically increasing");
                if (dep0.value(0) > dep0.value(dep0.length() - 1)) {
                    this.ds = Ops.copy((QDataSet)Ops.reverse((QDataSet)this.ds));
                    dep0 = SemanticOps.xtagsDataSet((QDataSet)this.ds);
                    if (!DataSetUtil.isMonotonicAndIncreasing((QDataSet)dep0)) {
                        logger.warning("reversed TCA dataset still contains non-monotonic tags");
                        this.ds = Ops.ensureMonotonicAndIncreasingWithFill((QDataSet)this.ds);
                    } else {
                        logger.info("reversing TCA dataset makes tags monotonically increasing.");
                    }
                } else {
                    logger.warning("removing non-monotonically increasing tags of TCA dataset.");
                    this.ds = Ops.ensureMonotonicAndIncreasingWithFill((QDataSet)this.ds);
                }
            }
            this.tlim = DataSetUtil.guessCadenceNew((QDataSet)SemanticOps.xtagsDataSet((QDataSet)this.ds), (QDataSet)this.ds);
            if (this.tsb != null) {
                DatumRange dr = this.tsb.getTimeRange();
                QDataSet ext = Ops.extent((QDataSet)SemanticOps.xtagsDataSet((QDataSet)this.ds), null);
                double d0 = DatumRangeUtil.normalize((DatumRange)dr, (Datum)DataSetUtil.asDatum((QDataSet)ext.slice(0)));
                double d1 = DatumRangeUtil.normalize((DatumRange)dr, (Datum)DataSetUtil.asDatum((QDataSet)ext.slice(1)));
                logger.log(Level.FINE, "normalized after load: {0}-{1}", new Object[]{d0, d1});
            }
            this.bundleDs = (QDataSet)this.ds.property("BUNDLE_1");
            if (this.bundleDs == null) {
                DDataSet bds1;
                if (this.ds.rank() == 1) {
                    bds1 = DDataSet.createRank2((int)1, (int)0);
                    String name = (String)this.ds.property("NAME");
                    String label = (String)this.ds.property("LABEL");
                    bds1.putProperty("NAME", 0, (Object)(name == null ? "ds0" : name));
                    bds1.putProperty("LABEL", 0, (Object)(label == null ? (name == null ? "" : name) : label));
                    if (this.ds.property("VALID_MIN") != null) {
                        bds1.putProperty("VALID_MIN", 0, this.ds.property("VALID_MIN"));
                    }
                    if (this.ds.property("VALID_MAX") != null) {
                        bds1.putProperty("VALID_MAX", 0, this.ds.property("VALID_MAX"));
                    }
                    if (this.ds.property("FILL_VALUE") != null) {
                        bds1.putProperty("FILL_VALUE", 0, this.ds.property("FILL_VALUE"));
                    }
                    this.bundleDs = bds1;
                } else {
                    bds1 = DDataSet.createRank2((int)this.ds.length(0), (int)0);
                    QDataSet dep1 = (QDataSet)this.ds.property("DEPEND_1");
                    Units u = dep1 == null ? Units.dimensionless : SemanticOps.getUnits((QDataSet)dep1);
                    for (int i = 0; i < this.ds.length(0); ++i) {
                        String name = dep1 != null ? u.createDatum(dep1.value(i)).toString() : (String)this.ds.property("NAME");
                        String label = (String)this.ds.property("LABEL");
                        bds1.putProperty("NAME", i, (Object)("ds" + i));
                        bds1.putProperty("LABEL", i, (Object)(label == null ? (name == null ? "" : name) : label));
                    }
                    this.bundleDs = bds1;
                }
            }
        }
        if (this.tsb == null) {
            this.tsb = (TimeSeriesBrowse)this.dss.getCapability(TimeSeriesBrowse.class);
        }
    }

    private boolean isValid(QDataSet result) {
        QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)result);
        if (wds.rank() == 0) {
            return wds.value() > 0.0;
        }
        boolean valid = true;
        for (int i = 0; i < wds.length(); ++i) {
            valid = valid && wds.value(i) > 0.0;
        }
        return valid;
    }

    public synchronized QDataSet values(QDataSet parms) {
        QDataSet gcd;
        if (this.initialError != null && this.ds == null) {
            return new BundleDataSet(this.error);
        }
        WritableDataSet tt = Ops.copy((QDataSet)Ops.unbundle((QDataSet)parms, (int)0));
        QDataSet dtt = Ops.diff((QDataSet)tt);
        try {
            gcd = DataSetUtil.gcd((QDataSet)dtt, (QDataSet)Ops.divide((Object)dtt.slice(0), (Object)100));
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            gcd = Ops.reduceMin((QDataSet)dtt, (int)0);
        }
        DatumRange dr = null;
        for (int i = 0; i < parms.length(); ++i) {
            Datum d = DataSetUtil.asDatum((QDataSet)parms.slice(i).slice(0));
            dr = DatumRangeUtil.union(dr, (Datum)d);
        }
        Datum neededResolution = DataSetUtil.asDatum((QDataSet)gcd).divide(2.0);
        logger.log(Level.FINE, "loading TCAs at {0} (gcd={1})", new Object[]{neededResolution, gcd});
        if (this.tsb != null) {
            DatumRange timeRange = this.tsb.getTimeRange();
            Datum resolution = this.tsb.getTimeResolution();
            this.tsb.setTimeRange(dr);
            if (timeRange == null || !timeRange.contains(dr) || resolution != null && neededResolution.lt(resolution)) {
                this.tsb.setTimeResolution(neededResolution);
                this.needToRead = true;
            }
        }
        return super.values(parms);
    }

    public synchronized QDataSet value(QDataSet parm) {
        DatumRange dr;
        if (this.initialError != null && this.ds == null) {
            return new BundleDataSet(this.error);
        }
        Datum d = DataSetUtil.asDatum((QDataSet)parm.slice(0));
        QDataSet context = (QDataSet)parm.property("CONTEXT_0", 0);
        QDataSet deltaMinus = (QDataSet)parm.property("DELTA_MINUS", 0);
        QDataSet deltaPlus = (QDataSet)parm.property("DELTA_PLUS", 0);
        boolean read = this.needToRead;
        if (this.tsb != null && !DatumRangeUtil.sloppyContains((DatumRange)(dr = this.tsb.getTimeRange()), (Datum)d)) {
            while (d.ge(dr.max())) {
                dr = dr.next();
                read = true;
            }
            while (d.lt(dr.min())) {
                dr = dr.previous();
                read = true;
            }
            if (read) {
                double check;
                if (context != null && ((check = DatumRangeUtil.normalize((DatumRange)dr, (Datum)DataSetUtil.asDatumRange((QDataSet)context).min())) < -100.0 || check > 200.0)) {
                    System.err.println("check suppressed bad read...");
                    context = null;
                }
                if (context != null) {
                    dr = DatumRangeUtil.union((DatumRange)dr, (DatumRange)DataSetUtil.asDatumRange((QDataSet)context, (boolean)true));
                }
                this.tsb.setTimeRange(dr);
            }
        }
        try {
            QDataSet result;
            QDataSet findex;
            if (read) {
                this.doRead();
                logger.log(Level.FINER, "loaded dataset: {0} {1} ", new Object[]{this.tsb != null ? this.tsb.getTimeRange() : "", this.ds});
            }
            if (this.ds == null) {
                BundleDataSet result2 = new BundleDataSet(this.errorNoDs);
                result2.putProperty("UNITS", this.errorNoDs.property("UNITS"));
                return result2;
            }
            QDataSet dep0 = SemanticOps.xtagsDataSet((QDataSet)this.ds);
            QDataSet d0 = parm.slice(0);
            if (dep0.length() == 1) {
                findex = Ops.dataset((Object)0);
            } else {
                findex = Ops.findex((QDataSet)dep0, (QDataSet)d0);
                if (Math.abs(findex.value() % 1.0) > 0.1) {
                    logger.log(Level.FINE, "interpolating to calculate tick for {0}", d);
                }
            }
            if (findex.value() >= -0.5 && findex.value() < (double)dep0.length() - 0.5) {
                int ii = (int)(findex.value() + 0.5);
                result = this.ds.slice(ii);
                if (!this.isValid(result)) {
                    int imax;
                    int imin;
                    if (deltaPlus == null) {
                        deltaPlus = DataSetUtil.asDataSet((Datum)SemanticOps.getUnits((QDataSet)dep0).getOffsetUnits().createDatum(0));
                    }
                    if (deltaMinus == null) {
                        deltaMinus = deltaPlus;
                    }
                    if ((imin = (int)((findex = Ops.findex((QDataSet)dep0, (QDataSet)Ops.subtract((QDataSet)d0, (QDataSet)deltaMinus))).value() + 0.5)) < 0) {
                        imin = 0;
                    }
                    if ((imax = (int)((findex = Ops.findex((QDataSet)dep0, (QDataSet)Ops.add((QDataSet)d0, (QDataSet)deltaPlus))).value() + 0.5)) >= dep0.length()) {
                        imax = dep0.length() - 1;
                    }
                    int irad = Math.max(ii - imin, imax - ii);
                    for (int iiii = 1; !(iiii >= irad || ii - iiii >= imin && this.isValid(result = this.ds.slice(ii - iiii)) || ii + iiii <= imax && this.isValid(result = this.ds.slice(ii + iiii))); ++iiii) {
                    }
                } else {
                    QDataSet delta;
                    logger.log(Level.FINER, "findex={0} for {1} {2}", new Object[]{findex, d0, result});
                    if (deltaPlus != null && Ops.gt((QDataSet)(delta = Ops.magnitude((QDataSet)Ops.subtract((QDataSet)d0, (QDataSet)dep0.slice(ii)))), (QDataSet)this.tlim).value() == 1.0) {
                        BundleDataSet result1 = new BundleDataSet(this.nonValueDs);
                        for (int i = 1; i < this.ds.length(0); ++i) {
                            result1.bundle(this.nonValueDs);
                        }
                        result = result1;
                    }
                }
            } else {
                QDataSet result3;
                if (deltaPlus == null) {
                    deltaPlus = DataSetUtil.asDataSet((Datum)SemanticOps.getUnits((QDataSet)dep0).getOffsetUnits().createDatum(0));
                }
                if (deltaMinus == null) {
                    deltaMinus = deltaPlus;
                }
                if (findex.value() > (double)(dep0.length() - 1) && Ops.ge((QDataSet)Ops.add((QDataSet)dep0.slice(dep0.length() - 1), (QDataSet)deltaMinus), (QDataSet)d0).value() == 1.0) {
                    result3 = this.ds.slice(dep0.length() - 1);
                } else if (findex.value() < 0.0 && Ops.le((QDataSet)Ops.subtract((QDataSet)dep0.slice(0), (QDataSet)deltaPlus), (QDataSet)d0).value() == 1.0) {
                    result3 = this.ds.slice(0);
                } else if (this.tsb == null) {
                    BundleDataSet result1 = new BundleDataSet(this.nonValueDs);
                    for (int i = 1; i < this.ds.length(0); ++i) {
                        result1.bundle(this.nonValueDs);
                    }
                    result3 = result1;
                    ((MutablePropertyDataSet)result3).putProperty("UNITS", this.nonValueDs.property("UNITS"));
                } else if (this.tsb.getTimeRange().contains(DataSetUtil.asDatum((QDataSet)d0))) {
                    BundleDataSet result1 = new BundleDataSet(this.nonValueDs);
                    for (int i = 1; i < this.ds.length(0); ++i) {
                        result1.bundle(this.nonValueDs);
                    }
                    result3 = result1;
                    ((MutablePropertyDataSet)result3).putProperty("UNITS", this.nonValueDs.property("UNITS"));
                } else {
                    logger.log(Level.INFO, "tick {0} is outside bounds of loaded data ({1}) {2}", new Object[]{DataSetUtil.asDatum((QDataSet)d0), this.tsb.getTimeRange(), this.ds});
                    BundleDataSet result1 = new BundleDataSet(this.error);
                    for (int i = 1; i < this.ds.length(0); ++i) {
                        result1.bundle(this.error);
                    }
                    result3 = result1;
                    ((MutablePropertyDataSet)result3).putProperty("UNITS", this.error.property("UNITS"));
                }
                return result3;
            }
            if (result.rank() == 0) {
                result = new BundleDataSet(result);
            }
            ((MutablePropertyDataSet)result).putProperty("BUNDLE_0", (Object)this.bundleDs);
            return result;
        }
        catch (Exception lex) {
            logger.log(Level.WARNING, lex.getMessage(), lex);
            lex.printStackTrace();
            return new BundleDataSet(this.error);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized QDataSet exampleInput() {
        if (this.exampleInput != null) {
            return this.exampleInput;
        }
        if (this.initialError != null) {
            label = "???";
            tu = Units.us2000;
            t0 = tu.createDatum(0);
        } else if (this.tsb != null) {
            t0 = this.tsb.getTimeRange().min();
            tu = t0.getUnits();
            label = "Time";
            if (this.needToRead) {
                try {
                    this.doRead();
                    dep0 = (QDataSet)this.ds.property("DEPEND_0");
                    if (dep0 == null) ** GOTO lbl39
                    t0 = DataSetUtil.asDatum((QDataSet)dep0.slice(0));
                    tu = t0.getUnits();
                    label = "???";
                }
                catch (Exception ex) {
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex);
                }
            }
        } else {
            try {
                if (this.needToRead) {
                    this.doRead();
                }
                if ((dep0 = (QDataSet)this.ds.property("DEPEND_0")) == null) {
                    throw new RuntimeException("Unable to locate independent variable, expecting to find DEPEND_0");
                }
                t0 = DataSetUtil.asDatum((QDataSet)dep0.slice(0));
                tu = t0.getUnits();
                label = "???";
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }
lbl39:
        // 5 sources

        inputDescriptor = DDataSet.createRank2((int)1, (int)0);
        inputDescriptor.putProperty("LABEL", 0, (Object)label);
        inputDescriptor.putProperty("UNITS", 0, (Object)tu);
        q = DataSetUtil.asDataSet((Datum)t0);
        ret = (MutablePropertyDataSet)Ops.bundle(null, (QDataSet)q);
        inputDescriptor.putProperty("CADENCE", (Object)DataSetUtil.asDataSet((Datum)Units.seconds.createDatum(1)));
        ret.putProperty("BUNDLE_0", (Object)inputDescriptor);
        this.exampleInput = ret;
        return ret;
    }
}

